/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import com.filenet.api.collection.GroupSet;
import com.filenet.api.collection.RealmSet;
import com.filenet.api.collection.UserSet;
import com.filenet.api.constants.FilteredPropertyType;
import com.filenet.api.constants.PrincipalSearchAttribute;
import com.filenet.api.constants.PrincipalSearchSortType;
import com.filenet.api.constants.PrincipalSearchType;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EntireNetwork;
import com.filenet.api.core.Factory;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.security.Group;
import com.filenet.api.security.Realm;
import com.filenet.api.security.User;
import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.base.logging.Logger;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Locale;

public class ORBFetchParticipants
implements PrivilegedExceptionAction {
    static final String m_className = "ORBFetchParticipants";
    protected static Logger logger = Logger.getLogger("filenet.pe.peorb.client");
    private static final long serialVersionUID = 464L;
    protected static final long INTERNAL_NUM = 234L;
    private String m_cempURI = null;
    private String m_domainName = null;
    private String[] m_theUserNameList = null;
    private long m_rpcArgFlag = 0L;
    private static PropertyFilter pf = null;

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:45:30  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.14  $";
    }

    protected ORBFetchParticipants(String paramCEMPURL, String paramdomainName, String[] paramtheUserNameList, long paramrpcArgFlag) throws VWException {
        this.m_cempURI = paramCEMPURL;
        this.m_domainName = this.nullCheck(paramdomainName);
        this.m_theUserNameList = paramtheUserNameList;
        this.m_rpcArgFlag = paramrpcArgFlag;
    }

    private String nullCheck(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public Object run() throws VWException {
        String m_method = "run";
        int limit = this.m_theUserNameList.length;
        VWParticipant[] results = new VWParticipant[limit];
        for (int j = 0; j < limit; ++j) {
            results[j] = null;
        }
        boolean[] duplicateName = new boolean[limit];
        boolean[] specialHandling = new boolean[limit];
        boolean[] checkedStrangeName = new boolean[limit];
        String[] shortName = new String[limit];
        for (int j = 0; j < limit; ++j) {
            duplicateName[j] = false;
            checkedStrangeName[j] = false;
            specialHandling[j] = this.m_theUserNameList[j].indexOf(61) != -1 || this.m_theUserNameList[j].indexOf(64) != -1 || this.m_theUserNameList[j].indexOf(47) != -1 || this.m_theUserNameList[j].indexOf(58) != -1;
        }
        Connection myConnection = Factory.Connection.getConnection((String)this.m_cempURI);
        EntireNetwork entireNetwork = Factory.EntireNetwork.fetchInstance((Connection)myConnection, null);
        RealmSet allRealms = entireNetwork.get_AllRealms();
        for (Realm realm : allRealms) {
            boolean explicitDomainSpecified;
            String realmName = realm.get_Name();
            boolean bl = explicitDomainSpecified = this.m_domainName.length() > 0;
            if (!explicitDomainSpecified || explicitDomainSpecified && realmName.toUpperCase(Locale.ENGLISH).equals(this.m_domainName.toUpperCase(Locale.ENGLISH))) {
                for (int i = 0; i < limit; ++i) {
                    GroupSet theGroups;
                    Iterator groupIter;
                    String searchPattern = this.m_theUserNameList[i];
                    if (logger.isFinest()) {
                        logger.finest(m_className, "run", "  Processing Realm: " + realmName);
                        logger.finest(m_className, "run", "   searchPattern=" + searchPattern + ", searchType=EXACT");
                    }
                    if (specialHandling[i]) {
                        if (!checkedStrangeName[i]) {
                            try {
                                if (logger.isFinest()) {
                                    logger.finest(m_className, "run", "Trying to find User " + searchPattern + " via Factory.User.fetchInstance");
                                }
                                User user = Factory.User.fetchInstance((Connection)myConnection, (String)searchPattern, (PropertyFilter)pf);
                                checkedStrangeName[i] = true;
                                shortName[i] = "";
                                if (user != null) {
                                    shortName[i] = user.get_ShortName();
                                    if (logger.isFinest()) {
                                        logger.finest(m_className, "run", "Found " + searchPattern + " - Short Name is " + shortName[i]);
                                    }
                                }
                            }
                            catch (Throwable t) {
                                shortName[i] = "";
                            }
                        }
                    } else {
                        shortName[i] = searchPattern;
                    }
                    if ("".equals(shortName[i])) continue;
                    UserSet theUsers = realm.findUsers(shortName[i], PrincipalSearchType.EXACT, PrincipalSearchAttribute.SHORT_NAME, PrincipalSearchSortType.ASCENDING, new Integer(0), pf);
                    Iterator userIter = theUsers.iterator();
                    if (userIter.hasNext()) {
                        User user = (User)userIter.next();
                        if (!duplicateName[i]) {
                            if (results[i] == null) {
                                results[i] = VWClassFactory.createVWParticipant(realmName, user.get_ShortName(), user.get_DistinguishedName(), user.get_DisplayName(), user.get_Id(), 0L, 1, 234L);
                            } else {
                                duplicateName[i] = true;
                                results[i] = null;
                            }
                        }
                        if (userIter.hasNext()) {
                            duplicateName[i] = true;
                            results[i] = null;
                        }
                    }
                    if (results[i] != null || duplicateName[i] || !(groupIter = (theGroups = realm.findGroups(shortName[i], PrincipalSearchType.EXACT, PrincipalSearchAttribute.SHORT_NAME, PrincipalSearchSortType.ASCENDING, new Integer(0), pf)).iterator()).hasNext()) continue;
                    Group group = (Group)groupIter.next();
                    if (!duplicateName[i]) {
                        if (results[i] == null) {
                            results[i] = VWClassFactory.createVWParticipant(realmName, group.get_ShortName(), group.get_DistinguishedName(), group.get_DisplayName(), group.get_Id(), 0L, 2, 234L);
                        } else {
                            duplicateName[i] = true;
                            results[i] = null;
                        }
                    }
                    if (!groupIter.hasNext()) continue;
                    duplicateName[i] = true;
                    results[i] = null;
                }
            }
            if (!explicitDomainSpecified || !realmName.toUpperCase(Locale.ENGLISH).equals(this.m_domainName.toUpperCase(Locale.ENGLISH))) continue;
            return results;
        }
        return results;
    }

    static {
        pf = new PropertyFilter();
        pf.addIncludeType(1, null, null, FilteredPropertyType.ANY);
        pf.addExcludeProperty("ClassDescriptions");
    }
}

